package net.kldp.logviewer;

import net.kldp.logviewer.model.LogViewer;
import net.kldp.logviewer.model.LogViewerEntry;
import net.kldp.logviewer.model.LogViewerGroup;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;


public class LogAdapterFactory implements IAdapterFactory {

	private IWorkbenchAdapter groupAdapter = new IWorkbenchAdapter() {
		public Object getParent(Object o) {
			return ((LogViewerGroup) o).getParent();
		}

		public String getLabel(Object o) {
			LogViewerGroup group = ((LogViewerGroup) o);
			int available = 0;
			LogViewer[] entries = group.getEntries();
			for (int i = 0; i < entries.length; i++) {
				LogViewer contact = entries[i];
//				if (contact instanceof LogViewerEntry) {
//					if (((LogViewerEntry) contact).getPresence() != Presence.INVISIBLE)
//						available++;
//				}
			}
			
			return group.getName();
		}

		public ImageDescriptor getImageDescriptor(Object object) {
			return AbstractUIPlugin.imageDescriptorFromPlugin(Application.PLUGIN_ID, IImageKeys.GROUP);
		}

		public Object[] getChildren(Object o) {
			return ((LogViewerGroup) o).getEntries();
		}
	};

	private IWorkbenchAdapter entryAdapter = new IWorkbenchAdapter() {
		public Object getParent(Object o) {
			return ((LogViewerEntry) o).getParent();
		}

		public String getLabel(Object o) {
			LogViewerEntry entry = ((LogViewerEntry) o);
			return entry.getName() + " (" + entry.getPath() + ", " + entry.getDelaySecond() + ")";
		}

		public ImageDescriptor getImageDescriptor(Object object) {
			LogViewerEntry entry = ((LogViewerEntry) object);
//			String key = presenceToKey(entry.getPresence());
			
			return AbstractUIPlugin.imageDescriptorFromPlugin(Application.PLUGIN_ID, IImageKeys.LOG_START);
		}

		public Object[] getChildren(Object o) {
			return new Object[0];
		}
	};

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType == IWorkbenchAdapter.class
				&& adaptableObject instanceof LogViewerGroup)
			return groupAdapter;
		if (adapterType == IWorkbenchAdapter.class
				&& adaptableObject instanceof LogViewerEntry)
			return entryAdapter;
		
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { IWorkbenchAdapter.class };
	}

}
